<?php
namespace App\Controllers;

use App\Models\Tournament;

class TournamentController {
    public static function dashboard() {
        require_login();
        $stats = [
            'tournaments' => Tournament::count(),
            'teams' => \App\Models\Team::count(),
            'matches' => \App\Models\MatchModel::count()
        ];
        view('auth/dashboard', compact('stats'));
    }

    public static function index() {
        require_login();
        $items = Tournament::all();
        view('tournaments/index', compact('items'));
    }

    public static function create() {
        require_login();
        view('tournaments/create');
    }

    public static function store() {
        require_login();
        $name = $_POST['name'] ?? '';
        $season = $_POST['season'] ?? '';
        Tournament::create($name, $season);
        redirect('tournaments');
    }
}
